/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.util;

import com.aptana.plist.IPListParser;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryPListParser
implements IPListParser {
    private static final boolean DEBUG = false;
    private int refCount;
    private int topLevelOffset;
    private ArrayList<Object> objectTable;

    protected static Object convert(Object obj) {
        if (obj instanceof BPLDict) {
            return ((BPLDict)obj).toMap();
        }
        if (obj instanceof BPLArray) {
            return ((BPLArray)obj).toList();
        }
        if (obj instanceof BPLUid) {
            return ((BPLUid)obj).getNumber();
        }
        return obj;
    }

    @Override
    public Map<String, Object> parse(File file) throws IOException {
        RandomAccessFile raf = null;
        byte[] buf = null;
        try {
            raf = new RandomAccessFile(file, "r");
            int bpli = raf.readInt();
            int st00 = raf.readInt();
            if (bpli != 1651534953 || st00 != 1936994352) {
                throw new IOException("parseHeader: File does not start with 'bplist00' magic.");
            }
            raf.seek(raf.length() - 32L);
            raf.readLong();
            this.refCount = (int)raf.readLong();
            raf.readLong();
            this.topLevelOffset = (int)raf.readLong();
            buf = new byte[this.topLevelOffset - 8];
            raf.seek(8L);
            raf.readFully(buf);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        this.objectTable = new ArrayList();
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new ByteArrayInputStream(buf));
            this.parseObjectTable((DataInputStream)in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return ((BPLDict)this.objectTable.get(0)).toMap();
    }

    private void parseObjectTable(DataInputStream in) throws IOException {
        int marker;
        while ((marker = in.read()) != -1) {
            switch ((marker & 0xF0) >> 4) {
                case 0: {
                    this.parsePrimitive(in, marker & 0xF);
                    break;
                }
                case 1: {
                    int count = 1 << (marker & 0xF);
                    this.parseInt(in, count);
                    break;
                }
                case 2: {
                    int count = 1 << (marker & 0xF);
                    this.parseReal(in, count);
                    break;
                }
                case 3: {
                    if ((marker & 0xF) != 3) {
                        throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                    }
                    this.parseDate(in);
                    break;
                }
                case 4: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    this.parseData(in, count);
                    break;
                }
                case 5: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    this.parseAsciiString(in, count);
                    break;
                }
                case 6: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    this.parseUnicodeString(in, count);
                    break;
                }
                case 7: {
                    return;
                }
                case 8: {
                    int count = (marker & 0xF) + 1;
                    this.parseUID(in, count);
                    break;
                }
                case 9: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                }
                case 10: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    if (this.refCount > 255) {
                        this.parseShortArray(in, count);
                        break;
                    }
                    this.parseByteArray(in, count);
                    break;
                }
                case 11: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                }
                case 12: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                }
                case 13: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    if (this.refCount > 256) {
                        this.parseShortDict(in, count);
                        break;
                    }
                    this.parseByteDict(in, count);
                    break;
                }
                case 14: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                }
                case 15: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                }
            }
        }
    }

    private int readCount(DataInputStream in) throws IOException {
        int marker = in.read();
        if (marker == -1) {
            throw new IOException("variableLengthInt: Illegal EOF in marker");
        }
        if ((marker & 0xF0) >> 4 != 1) {
            throw new IOException("variableLengthInt: Illegal marker " + Integer.toBinaryString(marker));
        }
        int count = 1 << (marker & 0xF);
        int value = 0;
        int i = 0;
        while (i < count) {
            int b = in.read();
            if (b == -1) {
                throw new IOException("variableLengthInt: Illegal EOF in value");
            }
            value = value << 8 | b;
            ++i;
        }
        return value;
    }

    private void parsePrimitive(DataInputStream in, int primitive) throws IOException {
        switch (primitive) {
            case 0: {
                this.objectTable.add(null);
                break;
            }
            case 8: {
                this.objectTable.add(Boolean.FALSE);
                break;
            }
            case 9: {
                this.objectTable.add(Boolean.TRUE);
                break;
            }
            case 15: {
                break;
            }
            default: {
                throw new IOException("parsePrimitive: illegal primitive " + Integer.toBinaryString(primitive));
            }
        }
    }

    private void parseByteArray(DataInputStream in, int count) throws IOException {
        BPLArray arr = new BPLArray();
        arr.objectTable = this.objectTable;
        arr.objref = new int[count];
        int i = 0;
        while (i < count) {
            arr.objref[i] = in.readByte() & 0xFF;
            if (arr.objref[i] == -1) {
                throw new IOException("parseByteArray: illegal EOF in objref*");
            }
            ++i;
        }
        this.objectTable.add(arr);
    }

    private void parseShortArray(DataInputStream in, int count) throws IOException {
        BPLArray arr = new BPLArray();
        arr.objectTable = this.objectTable;
        arr.objref = new int[count];
        int i = 0;
        while (i < count) {
            arr.objref[i] = in.readShort() & 0xFFFF;
            if (arr.objref[i] == -1) {
                throw new IOException("parseShortArray: illegal EOF in objref*");
            }
            ++i;
        }
        this.objectTable.add(arr);
    }

    private void parseData(DataInputStream in, int count) throws IOException {
        byte[] data = new byte[count];
        in.readFully(data);
        this.objectTable.add(data);
    }

    private void parseByteDict(DataInputStream in, int count) throws IOException {
        BPLDict dict = new BPLDict();
        dict.objectTable = this.objectTable;
        dict.keyref = new int[count];
        dict.objref = new int[count];
        int i = 0;
        while (i < count) {
            dict.keyref[i] = in.readByte() & 0xFF;
            ++i;
        }
        i = 0;
        while (i < count) {
            dict.objref[i] = in.readByte() & 0xFF;
            ++i;
        }
        this.objectTable.add(dict);
    }

    private void parseShortDict(DataInputStream in, int count) throws IOException {
        BPLDict dict = new BPLDict();
        dict.objectTable = this.objectTable;
        dict.keyref = new int[count];
        dict.objref = new int[count];
        int i = 0;
        while (i < count) {
            dict.keyref[i] = in.readShort() & 0xFFFF;
            ++i;
        }
        i = 0;
        while (i < count) {
            dict.objref[i] = in.readShort() & 0xFFFF;
            ++i;
        }
        this.objectTable.add(dict);
    }

    private void parseAsciiString(DataInputStream in, int count) throws IOException {
        byte[] buf = new byte[count];
        in.readFully(buf);
        String str = new String(buf, "ASCII");
        this.objectTable.add(str);
    }

    private void parseUID(DataInputStream in, int count) throws IOException {
        if (count > 4) {
            throw new IOException("parseUID: unsupported byte count: " + count);
        }
        byte[] uid = new byte[count];
        in.readFully(uid);
        this.objectTable.add(new BPLUid(new BigInteger(uid).intValue()));
    }

    private void parseInt(DataInputStream in, int count) throws IOException {
        if (count > 8) {
            throw new IOException("parseInt: unsupported byte count: " + count);
        }
        long value = 0L;
        int i = 0;
        while (i < count) {
            int b = in.read();
            if (b == -1) {
                throw new IOException("parseInt: Illegal EOF in value");
            }
            value = value << 8 | (long)b;
            ++i;
        }
        this.objectTable.add(new Long(value));
    }

    private void parseReal(DataInputStream in, int count) throws IOException {
        switch (count) {
            case 4: {
                this.objectTable.add(new Float(in.readFloat()));
                break;
            }
            case 8: {
                this.objectTable.add(new Double(in.readDouble()));
                break;
            }
            default: {
                throw new IOException("parseReal: unsupported byte count:" + count);
            }
        }
    }

    private void parseDate(DataInputStream in) throws IOException {
        double date = in.readDouble();
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.set(1, 2001);
        c.set(2, 0);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        while (date > 2.147483647E9) {
            c.add(13, Integer.MAX_VALUE);
            date -= 2.147483647E9;
        }
        c.add(13, (int)date);
        this.objectTable.add(c.getTime());
    }

    private void parseUnicodeString(DataInputStream in, int count) throws IOException {
        char[] buf = new char[count];
        int i = 0;
        while (i < count) {
            buf[i] = in.readChar();
            ++i;
        }
        String str = new String(buf);
        this.objectTable.add(str);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BPLArray {
        ArrayList<Object> objectTable;
        int[] objref;

        private BPLArray() {
        }

        public Object getValue(int i) {
            return this.objectTable.get(this.objref[i]);
        }

        public List<Object> toList() {
            ArrayList<Object> list = new ArrayList<Object>(this.objref.length);
            int i = 0;
            while (i < this.objref.length) {
                list.add(BinaryPListParser.convert(this.getValue(i)));
                ++i;
            }
            return list;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("Array{");
            int i = 0;
            while (i < this.objref.length) {
                if (i > 0) {
                    buf.append(',');
                }
                if (this.objectTable.size() > this.objref[i] && this.objectTable.get(this.objref[i]) != this) {
                    buf.append(this.objectTable.get(this.objref[i]));
                } else {
                    buf.append("*" + this.objref[i]);
                }
                ++i;
            }
            buf.append('}');
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BPLDict {
        ArrayList<Object> objectTable;
        int[] keyref;
        int[] objref;

        private BPLDict() {
        }

        public String getKey(int i) {
            return this.objectTable.get(this.keyref[i]).toString();
        }

        public Object getValue(int i) {
            return this.objectTable.get(this.objref[i]);
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>(this.keyref.length);
            int i = 0;
            while (i < this.keyref.length) {
                map.put(this.getKey(i), BinaryPListParser.convert(this.getValue(i)));
                ++i;
            }
            return map;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("BPLDict{");
            int i = 0;
            while (i < this.keyref.length) {
                if (i > 0) {
                    buf.append(',');
                }
                if (this.keyref[i] < 0 || this.keyref[i] >= this.objectTable.size()) {
                    buf.append("#" + this.keyref[i]);
                } else if (this.objectTable.get(this.keyref[i]) == this) {
                    buf.append("*" + this.keyref[i]);
                } else {
                    buf.append(this.objectTable.get(this.keyref[i]));
                }
                buf.append(":");
                if (this.objref[i] < 0 || this.objref[i] >= this.objectTable.size()) {
                    buf.append("#" + this.objref[i]);
                } else if (this.objectTable.get(this.objref[i]) == this) {
                    buf.append("*" + this.objref[i]);
                } else {
                    buf.append(this.objectTable.get(this.objref[i]));
                }
                ++i;
            }
            buf.append('}');
            return buf.toString();
        }
    }

    private static class BPLUid {
        private final int number;

        public BPLUid(int number) {
            this.number = number;
        }

        public int getNumber() {
            return this.number;
        }
    }
}

